/**
 * 引入所有组件和eventBus并暴露出去
 */
import { App, Plugin } from 'vue'
import EventBus from './util/event-bus'
import * as componentLib from '@/lib/index'

const install: Exclude<Plugin['install'], undefined> = function (app: App) {
  Object.entries(components).forEach(([componentName, component]) => {
    app.component(componentName, component)
  })
}

export const eventBus = EventBus
export const components = componentLib

export default install
