import TipsOutsite from '@/views/tips/outside'
import pudong from '@/router/pudongRoutes.json'
import xuhui from '@/router/xuhuiRoutes.json'
import huangpu from '@/router/huangpuRoutes.json'
import yangpu from '@/router/yangpuRoutes.json'
import ajax from '@/server/ajax'
import api from '@/server/api'
import documents from '@/router/documentsRoutes.json'
import Store from '@/store/index'

async function GetRoutes(router) {
  let env = process.env.NODE_ENV
  // console.log(env)
  let MicRouters
  switch (env) {
  // case env.indexOf('pudong') > -1: // 根据当前打包的项目调用该项目对应的路由
  case 'pudong-sit':
    MicRouters = pudong
    break
    
  case 'pudong-prod':
    MicRouters = pudong
    break
  
    // case env.indexOf('xuhui') > -1:
  case 'xuhui-sit':
    MicRouters = xuhui
    break
  
  case 'xuhui-prod':
    MicRouters = xuhui
    break

  case 'huangpu-sit':
    MicRouters = huangpu
    break
  
  case 'huangpu-prod':
    MicRouters = huangpu
    break

  case 'yangpu-sit':
    MicRouters = yangpu
    break
  
  case 'yangpu-prod':
    MicRouters = yangpu
    break
      
  default: // 当前仅可使用pudong / xuhui-sit/uat进行打包
    MicRouters = yangpu
    break
  }

  await function() {
    ajax.get({
      url: api.GET_USER_INFO,
    }).then(res => { 
      // 本地存储用户基本信息
      if (env.indexOf('xuhui') != -1 && res.data.content.isAllPerm) {
        let newArr= []
        MicRouters.Layout.forEach((item) => {
          if (item.name != 'tousu' && item.name != 'Disposal' ) {
            newArr.push(item)
          }
        })
        MicRouters.Layout = newArr
      }
    })
  }()

  // 徐汇区的子项目要看当前用户是否是超管,否则不展示 处置单和投诉
  // console.log(Store.state.userInfos)
  // if (env.indexOf('xuhui') != -1 ) {
  //   let newArr= []
  //   MicRouters.Layout.forEach((item) => {
  //     if (item.name != 'tousu' && item.name != 'Disposal' ) {
  //       newArr.push(item)
  //     }
  //   })
  //   MicRouters.Layout = newArr
  // }

  const micSystemRoutersConfigs = Object.assign({}, MicRouters)
  const { routes } = router.options
  const parent = routes.find(item => item.name === 'Layout')

  for (let key in micSystemRoutersConfigs) {
    for (let i = 0; i < micSystemRoutersConfigs[key].length; i++) {
      let firstRouter = Object.assign({}, micSystemRoutersConfigs[key][i])
      if (
        !!firstRouter.meta.openMode &&
        firstRouter.meta.openMode == 'outsite'
      ) {
        firstRouter.component = TipsOutsite
      }
      parent.children.push(Object.assign({}, firstRouter))
      router.addRoutes([ parent ])
    }
  }

  for(let key in documents) {
    for (let i = 0; i < documents[key].length; i++) {
      let firstRouter = Object.assign({}, documents[key][i])
      if (
        !!firstRouter.meta.openMode &&
        firstRouter.meta.openMode == 'outsite'
      ) {
        firstRouter.component = TipsOutsite
      }
      parent.children.push(Object.assign({}, firstRouter))
      router.addRoutes([ parent ])
    }
  }

  // console.log(router)

}

export default GetRoutes
