let BASE_URL = '', MOCK_URL='',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'
/**
 * todo
 * 1、此处配置当前项目在不同环境下的API请求前缀
 * 2、前端服务间、后端服务间需做跨域处理
 */
switch (process.env.NODE_ENV) {
case 'devol': // 本地线上部署环境下
  BASE_URL = 'http://xuhui.hm.omniview.pro/api/v2'

  break

case 'pudong-sit':
  BASE_URL = 'http://pudong.hm.omniview.pro/api/v2',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'pudong-prod':
  // BASE_URL = 'http://211.136.105.193/apiv2',
  BASE_URL = 'http://10.220.105.137:81/api'
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'xuhui-sit':
  BASE_URL = 'http://xuhui.hm.omniview.pro/api/v2',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'xuhui-prod':
  BASE_URL = 'http://31.0.161.39/apiv2',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'yangpu-sit':
  BASE_URL = 'http://yangpu-hm.omniview.pro/api/v2',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'yangpu-prod':
  BASE_URL = 'http://10.216.118.142/api',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'huangpu-sit':
  BASE_URL = 'http://huangpu.hm.omniview.pro/api/v2',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

case 'huangpu-prod':
  BASE_URL = 'http://172.82.26.1/api',
  FANGDI_URL = 'http://962121.fgj.sh.gov.cn/wyweb/shanghaiwuye'

  break

default: // 默认环境下（开发环境）
  // BASE_URL = 'http://31.0.161.39/apiv2'
  // BASE_URL = 'http://211.136.105.193/apiv2'
  BASE_URL = 'http://yangpu-hm.omniview.pro/api/v2'
  // BASE_URL = 'http://xuhui.hm.omniview.pro/api/v2'
  // BASE_URL = 'http://pudong.hm.omniview.pro/api/v2'
  // BASE_URL = 'http://211.136.105.193/apiv2'
  MOCK_URL = 'https://yapi.omniview.pro/mock/283'
  break
}
/**
 * 此处配置本项目涉及到的所有
 * 要求
 * 1、前端服务间、后端服务间需做跨域处理
 * 2、所有的API都需要注释说明，标记业务动作是什么
 * 3、在API的名称定义上，需体现本接口的请求方式。如USERINFO_POST、USERINFO_GET
 * 4、所有的API按功能模块要求，分段并注释说明
 */
export default {
  /**
   * 各类请求的BASE_URL
   */
  BASE_URL,

  GET_USER_INFO: '/service-user-ddd/login/user/info', // 获取用户信息

  PUT_PERSONAL_RESET_PWD: '/pwd', // 修改密码
  GET_HOME_DISPOSAL: '/service-special-xh-ddd/dashboard/disposal', //处置单统计
  GET_HOUSE_MONTH: '/service-documents-ddd/dashboard/house/month', //房办月查统计
  GET_ALREADY_OR_EXPIRE: '/service-basicdatasync-ddd/indCou/statistics/alreadyOrWillExpire',

  GET_KEYS: 'service-customkey-ddd/show/{table}/keys', // 某表下所有可显示的字段
  POST_KEYS: 'service-customkey-ddd/show/keys', // 保存已选字段
  GET_CAN_TBLS: 'service-customkey-ddd/tbls', // 可进行数据拓展的表
  GET_CONFIG: 'config', //判断自定义字段功能是否开启
  GET_PROJECT: '/service-basicdatasync-ddd/public/projectConfig', //查看项目信息
  POST_PROJECT: '/service-basicdatasync-ddd/projectConfig', //配置项目信息
  UPLOAD_TEMP: '/service-basicdatasync-ddd/img/temp', //项目图片上传

  GET_TBLS_LIST: 'service-customkey-ddd/tbls', // 可进行数据拓展的表
  POST_TBLS_KEYS: 'service-customkey-ddd/key', // 新增自定义字段
  PUT_TBLS_KEYS: 'service-customkey-ddd/key/{id}', // 修改自定义字段
  DELETE_TBLS_KEYS: 'service-customkey-ddd/key/{id}', // 删除自定义字段

  GET_TBLS_KEYS: 'service-customkey-ddd/keys', // 某表下有哪些自定义字段

  GET_EXT: '/service-basicdatasync-ddd/entity/{id}/ext', // 查看某数据的自定义信息
  POST_EXT: '/service-basicdatasync-ddd/entity/ext', // 保存某数据的自定义信息
  GET_SAFE_EXT: '/service-basicdatasync-ddd/{table}/entity/{id}/ext', // 维护自定义信息的借口
  POST_EXT_BATCH: '/service-basicdatasync-ddd/entity/ext/batch', // 批量操作

  GET_EXPORT: '/service-basicdatasync-ddd/export/{table}', //数据导出
  GET_EXPORT_EWM: BASE_URL+'/service-basicdatasync-ddd/public/qrCodeGenerate', //导出二维码

  GET_STREET_LIST: '/service-basicdatasync-ddd/streets', //街道下拉列表

  // 小区列表
  GET_BASIC_LIST: '/service-basicdatasync-ddd/communities',
  // 小区详情
  GET_BASIC_ID: '/service-basicdatasync-ddd/community/{id}',
  // 物业服务企业列表
  GET_PROPCOMPANIES_LIST: '/service-basicdatasync-ddd/propCompanies',
  // 物业服务企业详情
  GET_PROPCOMPANY_ID: '/service-basicdatasync-ddd/propCompany/{id}',
  // 小区管理处列表
  GET_CSS_LIST: '/service-basicdatasync-ddd/css',
  // 小区管理处详情
  GET_CS_ID: '/service-basicdatasync-ddd/css/{id}',
  // 小区经理列表
  GET_MANAGERS_LIST: '/service-basicdatasync-ddd/managers',
  // 小区经理详情
  GET_MANAGER_ID: '/service-basicdatasync-ddd/manager/{id}',
  // 业委会列表
  GET_INDCOUS_LIST: '/service-basicdatasync-ddd/indCous',
  // 业委会详情
  GET_INDCOU_ID: '/service-basicdatasync-ddd/indCou/{id}',
  // 非居列表
  GET_NONRESIDENTS_LIST: '/service-basicdatasync-ddd/nonResidents',
  // 非居详情
  GET_NONRESIDENT_ID: '/service-basicdatasync-ddd/nonResident/{id}',
  // 非居门牌幢列表
  GET_NONBUILDING_LIST: '/service-basicdatasync-ddd/nonResi/buildings', // /service-basicdatasync-ddd/nonResi/buildings
  // 非居门牌幢详情
  GET_NONBUILDING_ID: '/service-basicdatasync-ddd/nonResi/building/{id}', // /service-basicdatasync-ddd/nonResi/building/{id}
  // 小区楼栋列表
  GET_BUILDINGS_LIST: '/service-basicdatasync-ddd/community/buildings',
  // 小去楼栋详情
  GET_BUILDING_ID: '/service-basicdatasync-ddd/community/building/{id}',
  // 业委会成员列表
  GET_MEMBERS_LIST: '/service-basicdatasync-ddd/indcou/members',
  // 业委会成员详情
  GET_MEMBER_ID: '/service-basicdatasync-ddd/indcou/member/{id}',
  // 设施设备列表
  GET_FACEQUS_LIST: '/service-basicdatasync-ddd/community/facEqus',
  // 设备勘验
  GET_base_KANYAN_INFO: '/service-basicdatasync-ddd/facilitiesEquipmentLife/pages', // 设备勘验基础信息
  GET_ELE_KANYAN_LIST: '/service-basicdatasync-ddd/facilitiesEquipmentElevator/pages', // 设备勘验电梯列表
  GET_GATE_KANYAN_LIST: '/service-basicdatasync-ddd/facilitiesEquipmentElevatorDoor/pages', // 设备勘验大门列表

  // 房办列表
  GET_HOS_LIST: '/service-basicdatasync-ddd/hos',
  // 首页统计列表
  GET_RESOURE_LIST: '/service-basicdatasync-ddd/resource/count',
  // 首页统计列表
  POST_LOGIN: '/public/login',

  // 居委会列表
  GET_NEI_LIST: '/service-basicdatasync-ddd/residentsCommittees',
  // 居委会详情
  GET_NEI_ID: '/service-basicdatasync-ddd/residentsCommittees/{id}',

  /**
   * SSO
   */
  GET_TOKEN: BASE_URL+'/uaa/oauth/token', // 获取token
  /**
   * XXX审查
   */
  SHENGCHA_POST: '', // 提交需要XX审查的数据信息
  GET_REPAIR_STATISTICS: '/service-documents-ddd/reportBX/statistics', //应急报修统计
  GET_CHWECK_DATA: FANGDI_URL+'/propertyinspector/api/v1/sharingplatform/themeListForOneDay', //专项检查数据
  GET_JIANCHADIZHI: '/service-documents-ddd/generateUrl', //获取专项检查页面地址
  GET_WYGENERATE: '/service-documents-ddd/wywebgenerateUrl', //获取物业风险发现/处置地址
  GET_TOUSUQUESTION_INFO: '/service-documents-ddd/tsDetial', //投诉问题列表
  GET_TOUSUDENSITY_LIST: '/service-documents-ddd/tsDensityRank', //投诉密度排行
  GET_TOUSUQUESTION_DETAILS: '/service-documents-ddd/tsDetial/{id}', //投诉问题详情
  GET_TOUSUQUESTION_LIST: '/service-documents-ddd/tsRank', //投诉问题排行

  GET_FEE_STANDARD_LIST: '/service-basicdatasync-ddd/property/costs', // 物业收费详情

  /**
   * 首页dashboard
   */
  GET_IndustrySupervision: '/service-documents-ddd/statistical/hoMonthlyCheck/groupByStreet', //行业督查
  GET_RiskDisposal: '/service-special/discover/statistical/discoverHandle', //当年风险处置情况
  GET_ComplaintsTrain: '/service-report/elevator/ranking/{type}', //投诉直通车
  GET_Creditratingranking: '/service-special/crdt/evlt/levelRanking', //信用管理等级排行
  get_elevator_collect: 'service-report/elevator/collect', // 小区电梯加装情况

  // get_specialInspection: '/service-documents-ddd/statistical/specialInspection', //行业督查数字
  get_specialInspection: '/service-documents-ddd/statistical/specialInspection', //行业督查数字
  get_month_check: 'service-documents-ddd/dashboard/house/month',

  GET_LABEL_LIST: MOCK_URL + '/service-customkey-ddd/labels', // 获取标签列表

  GET_FB_WY_MANAGE_CHECK: '/service-documents-ddd/checkOrder/dahboard/countDatas', //首页-房办月查-物业双周查-经理自查
  
  //角色管理
  GET_ROLE_LIST: '/service-permission/roles', //获取角色列表
  ROLE_DETAIL: '/service-account/accounts', // 查询角色权限
  GET_USER_PEIMISSION: '/service-permission/user/perms', // 当前用户角色权限树 -- 传userId
  GET_ALL_PEIMISSION: '/service-permission/perms', // 全部角色权限树 
  GET_ALL_ROLE: '/service-permission/menu/tree', //获取权限
  
  GET_USER_CODE: '/service-permission/user/menus/code', //获取用户权限

  ROLE_DETAIL: '/service-permission/roles/{id}', // 查询角色权限
  ADD_ROLE_POST: '/service-permission/role', // 新增角色
  PUT_CHARACTER: '/service-permission/role/{id}', //编辑角色
  GET_CHARACTER: '/service-permission/role/{id}', //查看角色
  DELETE_CHARACTER: '/service-permission/role/{id}', //删除角色
  //用户管理
  GET_STAFF_LIST: '/service-user-ddd/users', //获取内部人员列表
  PUT_STAFF_PWD: '/service-user-ddd/reset/pwd', //内部人员密码修改
  GET_USER_DETAIL: '/service-user-ddd/user/{id}', //查询用户账号详情
  POST_ADD_USER: '/service-user-ddd/user', //管理员新增用户
  // PUT_STAFF_LIST: '/service-user-ddd/user', //修改内部人员列表
  GET_USERNAME_EXIST: '/service-user-ddd/public/check/username/exist', //校验用户名是否存在 
  GET_CHECK_PHONE_EXIST: '/public/check/phone/exist', //判断手机是否存在
  GET_REDIS: '/service-user-ddd/user/refresh/{id}', //后台刷新redis

  //日志管理
  GET_RIZHI: '/service-log/operateRecord', //日志列表
  GET_RIZHI_INFO: '/service-log/operateRecord/{id}', //日志详情

}
