// toChange : 需严格按下述要求完成router配置。且不允许使用懒加载模式的components引入方式
import Layout from '@/components/Layout/main'
import TipsNetworkErr from '@/views/errorTips/network'
import TipsNoAuth from '@/views/errorTips/auth'
import ContentWrapper from '@/components/Layout/content-wrapper'
import HomePage from '@/views/home'
import LoginPage from '@/views/login'
import PersonCenter from '@/views/person-center'
import basicInfo from '@/views/houseData/basicInfo'
import PropertyInfo from '@/views/houseData/propertyInfo'
import CmDivision from '@/views/houseData/cmDivision'
import Managers from '@/views/houseData/managers'
import IndCous from '@/views/houseData/indCous'
import NonResidents from '@/views/houseData/nonResidents'
import Buildings from '@/views/houseData/buildings'
import Members from '@/views/houseData/members'
import BasicView from '@/views/houseData/basicView'
import Shebei from '@/views/houseData/shebei'
import PropertyInfoView from '@/views/houseData/propertyInfoView'
import Tbls from '@/views/houseData/tbls'
import Demo from '@/views/components/demo'


// import TipsUpperLimitErr from '@/views/tips/upperlimit'
// import TipsNetworkErr from '@/views/tips/network'
// import TipsInnerNetworkErr from '@/views/tips/innerNetwork'
// import TipsNoAuth from '@/views/tips/auth'
// import TipsOutsite from '@/views/tips/outsite'

/**
 * 要求：
 *  1、配置Router时，需将此router的权限编码信息、打开方式信息、是否在面包屑隐藏信息、是否为左侧菜单、是否有菜单图标配置在内。
 *  2、如此路由节点是要在面包屑中展示的，则需严格按照路由父子级，将子路由定义在其直属父级路由的children中
 *  3、为页面渲layout，所有除’/‘外的路由，都需定在’/‘路由的children下
 * 作用：除去正常路由展示，系统会从本数组内抓取权限菜单、判断是否能在面包屑中显示
 * 特殊配置字段说明：
 * meta.menuPath 标记是否为菜单。不是可不设置此字段
 * meta.authCode 当此路由受权限控制，需设置此字段，并填写与服务端一直的权限编码。不受权限控制可不设置
 * meta.hideInBread 标记是否需在面包屑中展示。不是可不设置此字段
 * meta.menuIcon 标记此路由在展示时需显示的ant design的图标。只能填写ant design中ICON组件内允许的字符串
 * meta.openMode 标记此路由点击后展示打开的方式。若值为normal，可不设置此字段
 *               spa 注册子前端项目的路由。注，此时设置的router.name为子项目展现路由名称的name，且需带上子项目名称前缀。如：/{micname}/{子项目router.name}，且无需设定router.component
 *               normal 本项目中自有路由
 *               outsite 新开标签页打开，此打开方式将不嵌套layout
 * meta.outsiteLink 当meta.openMode 为outsite时，必须配置此字段，并设置完整跳转页面的href
 *
 */
export const menus = [
  {
    path: '/house', name: 'house', component:ContentWrapper,
    meta: { title: '住宅信息', menuPath: true, menuIcon: 'profile', hideInBread: true },
    children: [
      {     //    小区列表
        path: '/houseData/basicInfo', name: 'basicInfo',component: basicInfo,
        meta: { title: '小区列表', menuPath:true, hideInBread:false, },
        children:[
          {
            path: '/houseData/basicInfo/:id', name: 'basicView',component: BasicView,
            meta: { title: '小区详细情况', hideInBread:false, },

          },
          {
            path: '/houseData/buildings', name: 'buildings',component: Buildings,
            meta: { title: '门牌栋', hideInBread:false, },
            children:[
              {
                path: '/houseData/buildings/:id', name: 'buildingView',component: PropertyInfoView,
                meta: { title: '门牌栋详情',  hideInBread:false, }
              }
            ]
          },

          {
            path: '/houseData/shebei/:id', name: 'shebei',component: Shebei,
            meta: { title: '设施设备', menuPath:true, hideInBread:false,},
            children:[

            ]
          },
        ]
      },
      {   //   业委会列表
        path: '/houseData/indCous', name: 'indCous',component: IndCous,
        meta: { title: '业委会信息列表', menuPath:true, hideInBread:false,},
        children:[
          {
            path: '/houseData/indCou/:id', name: 'indCouView',component: PropertyInfoView,
            meta: { title: '业委会详细情况', menuPath:false,  hideInBread:false,},
          },
          {
            path: '/houseData/members', name: 'members',component: Members,
            meta: { title: '业委会成员列表', hideInBread:false, },
            children:[
              {
                path: '/houseData/member/:id', name: 'memberView',component: PropertyInfoView,
                meta: { title: '业委会成员详情',   hideInBread:false,}
              }
            ]
          },
        ]
      },
      {   //     物业列表
        path: '/houseData/propertyInfo', name: 'propertyInfo',component: PropertyInfo,
        meta: { title: '物业企业列表', menuPath:true, hideInBread:false,},
        children:[
          {
            path: '/houseData/propertyInfo/:id', name: 'propertyInfoView',component: PropertyInfoView,
            meta: { title: '物业服务企业详细情况',  hideInBread:false, }
          }
        ]
      },
      {   //     小区管理处
        path: '/houseData/cmDivision', name: 'cmDivision',component: CmDivision,
        meta: { title: '小区管理处列表', menuPath:true,hideInBread:false, },
        children:[
          {
            path: '/houseData/cmDivision/:id', name: 'cmDivisionView',component: PropertyInfoView,
            meta: { title: '小区管理处详细情况', menuPath:true, hideInBread:false, }
          }
        ]
      },
      {  //     小区经理
        path: '/houseData/managers', name: 'managers',component: Managers,
        meta: { title: '小区经理列表', menuPath:true, hideInBread:false,},
        children:[
          {
            path: '/houseData/managers/:id', name: 'managerView',component: PropertyInfoView,
            meta: { title: '小区经理详细情况', menuPath:false, hideInBread:false, }
          },
        ]
      },
    ]
  },
  {
    path: '/noN', name: 'feiju',component:ContentWrapper,redirect:{name:'home'},
    meta: { title: '非居信息', menuPath: true, menuIcon: 'profile', hideInBread: true },
    children: [
      { //   非居列表
        path: '/houseData/nonResidents', name: 'nonResidents',component: NonResidents,
        meta: { title: '非居项目信息列表', menuPath:true, hideInBread:false,},
        children:[
          {
            path: '/houseData/nonResident/:id', name: 'nonResidentsView',component: PropertyInfoView,
            meta: { title: '非居详细情况', menuPath:false, hideInBread:false, }
          },
        ]
      },
    ]
  },
  { //  拓展信息管理
    path: '/tbls', name: 'tbls',component: Tbls,
    meta: { title: '拓展信息管理', menuPath:true, menuIcon: 'setting',hideInBread:false,},
  },

]
const appRoutes = [
  {
    path: '/', name: 'Layout', redirect:{name:'home'},
    // toChange :需定义两个layout文件，分别用于子项目独立运行使用，和嵌入portal中使用
    component: Layout,
    // endChange
    children: [
      { path: '/home', name: 'home', component: HomePage,
        meta: { title: '首页', },
      },
      { path: '/person', name: 'person',component: PersonCenter,
        meta: { title: '个人中心' },
      },
      { path: '/noauth', name: 'noauth', component: TipsNoAuth,
        meta: { title: '无权访问', },
      },

      ...menus
    ],
  },
  {
    path: '/login',
    name: 'login',
    meta: { title: '登录'},
    component: LoginPage,
  },
  { path: '/networkerr', name: 'networkErr', component: TipsNetworkErr,
    meta: { title: '网络异常', },
  },
  { path: '/demo', name: 'demo', component: Demo,
    meta: { title: 'demo', },
  },
] 

export const routes = [
  ...appRoutes,
]


