import TipsOutsite from '@/views/tips/outside'
import pudong from '@/router/pudongRoutes.json'
import xuhui from '@/router/xuhuiRoutes.json'
import huangpu from '@/router/huangpuRoutes.json'
import yangpu from '@/router/yangpuRoutes.json'

async function GetRoutes(router) {
  let env = process.env.NODE_ENV
  // console.log(env)
  let MicRouters
  switch (env) {
  // case env.indexOf('pudong') > -1: // 根据当前打包的项目调用该项目对应的路由
  case 'pudong-sit':
    MicRouters = pudong
    break
    
  case 'pudong-prod':
    MicRouters = pudong
    break
  
    // case env.indexOf('xuhui') > -1:
  case 'xuhui-sit':
    MicRouters = xuhui
    break
  
  case 'xuhui-prod':
    MicRouters = xuhui
    break

  case 'huangpu-sit':
    MicRouters = huangpu
    break
  
  case 'huangpu-prod':
    MicRouters = huangpu
    break

  case 'yangpu-sit':
    MicRouters = yangpu
    break
  
  case 'yangpu-prod':
    MicRouters = yangpu
    break
      
  default: // 当前仅可使用pudong / xuhui-sit/uat进行打包
    MicRouters = pudong
    break
  }

  const micSystemRoutersConfigs = Object.assign({}, MicRouters)
  const { routes } = router.options
  const parent = routes.find(item => item.name === 'Layout')
  for (let key in micSystemRoutersConfigs) {
    for (let i = 0; i < micSystemRoutersConfigs[key].length; i++) {
      let firstRouter = Object.assign({}, micSystemRoutersConfigs[key][i])
      if (
        !!firstRouter.meta.openMode &&
        firstRouter.meta.openMode == 'outsite'
      ) {
        firstRouter.component = TipsOutsite
      }
      parent.children.push(Object.assign({}, firstRouter))
      router.addRoutes([ parent ])
    }
  }
}

export default GetRoutes
