import TipsOutsite from '@/views/tips/outside'
import pudong from '@/router/pudongRoutes.json'
import xuhui from '@/router/xuhuiRoutes.json'
import huangpu from '@/router/huangpuRoutes.json'
import yangpu from '@/router/yangpuRoutes.json'
import ajax from '@/server/ajax'
import api from '@/server/api'
import documents from '@/router/documentsRoutes.json'
import defaultRoutes from '@/router/defaultRoutes.json'
// import removeRoutes from '@/router/getRoutesChoose.js'
import routeByFilter from '@/router/routeByFilter.json'
import Store from '@/store/index'

/**
 * 
 * @param { defaultRoutes , documentsRoutes}    私有菜单(子项目) , 公共菜单(子项目)
 *  1. 当打包命令没有指定对应的区局,选用默认私有菜单文件 defaultRoutes(空的菜单) , 在下方会耦合 documentsRoutes(公共菜单) 内的全部菜单做展示
 *  2. 打包命令包含区局的情况下, 选用对应区局的私有菜单文件, 并在getRoutesChoose文件中过滤需要展示的documentsRoutes内的菜单,在下方耦合
 * 
 */
console.log(routeByFilter)

async function GetRoutes(router) {
  let env = process.env.NODE_ENV
  // console.log(env)
  let MicRouters
  switch (env) {
  case 'pudong-sit':
    pudong.Layout = pudong.Layout.concat('pudong' in routeByFilter ? routeByFilter.pudong : documents.Layout )   
    MicRouters = pudong
    break
  case 'pudong-prod':
    pudong.Layout = pudong.Layout.concat('pudong' in routeByFilter ? routeByFilter.pudong : documents.Layout )   
    MicRouters = pudong
    break
  case 'xuhui-sit':
    xuhui.Layout = xuhui.Layout.concat('xuhui' in routeByFilter ? routeByFilter.xuhui : documents.Layout )   
    MicRouters = xuhui
    break
  case 'xuhui-prod':
    xuhui.Layout = xuhui.Layout.concat('xuhui' in routeByFilter ? routeByFilter.xuhui : documents.Layout )   
    MicRouters = xuhui
    break
  case 'huangpu-sit':
    huangpu.Layout = huangpu.Layout.concat('huangpu' in routeByFilter ? routeByFilter.huangpu : documents.Layout )   
    MicRouters = huangpu
    break
  case 'huangpu-prod':
    huangpu.Layout = huangpu.Layout.concat('huangpu' in routeByFilter ? routeByFilter.huangpu : documents.Layout )   
    MicRouters = huangpu
    break
  case 'yangpu-sit':
    yangpu.Layout = yangpu.Layout.concat('yangpu' in routeByFilter ? routeByFilter.yangpu : documents.Layout )   
    MicRouters = yangpu
    break
  case 'yangpu-prod':
    yangpu.Layout = yangpu.Layout.concat('yangpu' in routeByFilter ? routeByFilter.yangpu : documents.Layout )   
    MicRouters = yangpu
    break
  case 'development': // 本地开发展示对应的子项目路由
    xuhui.Layout = xuhui.Layout.concat('xuhui' in routeByFilter ? routeByFilter.xuhui : documents.Layout )   
    MicRouters = xuhui
    break
  default: // 当命令没有指定的情况下会选用空的私有菜单
    MicRouters = documents
    break
  }

  await function() {
    ajax.get({
      url: api.GET_USER_INFO,
    }).then(res => { 
      // 本地存储用户基本信息
      if (env.indexOf('xuhui') != -1 && res.data.content.isAllPerm) {
        let newArr= []
        MicRouters.Layout.forEach((item) => {
          if (item.name != 'tousu' && item.name != 'Disposal' ) {
            newArr.push(item)
          }
        })
        MicRouters.Layout = newArr
      }
    })
  }()

  const micSystemRoutersConfigs = Object.assign({}, MicRouters)
  const { routes } = router.options
  const parent = routes.find(item => item.name === 'Layout')

  for (let key in micSystemRoutersConfigs) {
    for (let i = 0; i < micSystemRoutersConfigs[key].length; i++) {
      let firstRouter = Object.assign({}, micSystemRoutersConfigs[key][i])
      if (
        !!firstRouter.meta.openMode &&
        firstRouter.meta.openMode == 'outsite'
      ) {
        firstRouter.component = TipsOutsite
      }
      parent.children.push(Object.assign({}, firstRouter))
      router.addRoutes([ parent ])
    }
  }

}

export default GetRoutes
