// import Layout from '@/components/Layout' 
// import Home from '@/views/home' 
// import LoginPage from '@/views/login'
// import PersonCenter from '@/views/person-center'
// import TipsNoAuth from '@/views/errorTips/auth' 
// import TipsNetworkErr from '@/views/errorTips/network' 
// import ContentWrapper from '@/components/Layout/content-wrapper' 
// import basicInfo from '@/views/houseData/basicInfo'
// import PropertyInfo from '@/views/houseData/propertyInfo'
// import CmDivision from '@/views/houseData/cmDivision'
// import Managers from '@/views/houseData/managers'
// import IndCous from '@/views/houseData/indCous'
// import NonResidents from '@/views/houseData/nonResidents'
// import Buildings from '@/views/houseData/buildings'
// import Members from '@/views/houseData/members'
// import BasicView from '@/views/houseData/basicView'
// import Shebei from '@/views/houseData/shebei'
// import PropertyInfoView from '@/views/houseData/propertyInfoView'
// import Tbls from '@/views/houseData/tbls'
// import Demo from '@/views/components/demo' 
const appRoutes = [
  {
    path: '/', name: 'Layout', redirect: '/portal-home',
    component: resolve => require(['@/components/Layout'], resolve), //Layout,
    children: [
      {
        path: '/portal-home', name: 'home', component: resolve => require(['@/views/home'], resolve), //Home,
        meta: { title: '首页' },
      }, 
      {
        path: '/dashBoard', name: 'dashBoard', component: resolve => require(['@/views/dashBoard'], resolve), //Home,
        meta: { title: '首页' },
      }, 
      { path: '/person', name: 'person', component: resolve => require(['@/views/person-center'], resolve), //PersonCenter,
        meta: { title: '个人中心' },
      },
      { path: '/noauth', name: 'noauth', component: resolve => require(['@/views/errorTips/auth'], resolve), //TipsNoAuth,
        meta: { title: '无权访问', },
      },
      {
        path: '/systemManagement', name: 'systemManagement', component: resolve => require(['@/components/Layout/content-wrapper'], resolve), //ContentWrapper,
        meta: { title: '系统管理', menuPath: true, menuIcon: 'profile', authCode: '0000', hideInBread: true },
        children: [
          { //   系统信息配置
            path: '/systemManagement/sysInfoSetting', name: 'sysInfoSetting', component: resolve => require(['@/views/personal/sysInfoSetting'], resolve), //NonResidents,
            meta: { title: '系统信息配置', menuPath: true, menuIcon: 'setting', authCode: '000001', hideInBread: false, },
            // children: [
            // ]
          },
          { //  拓展信息管理
            path: '/systemManagement/tbls', name: 'tbls', component: resolve => require(['@/views/houseData/tbls'], resolve), //Tbls,
            meta: { title: '拓展信息管理', menuPath: true, menuIcon: 'setting', authCode: '000002', hideInBread: false, },
          }, 
          { //  角色管理
            path: '/systemManagement/role', name: 'role', component: resolve => require(['@/views/personal/role/list'], resolve), //role,
            meta: { title: '角色管理', authCode: '000903', menuPath: true, menuIcon: 'cluster', hideInBread: false, },
            children: [ 
              {
                path: '/systemManagement/role/add', name: 'add', component: resolve => require(['@/views/personal/role/add'], resolve), //add,
                meta: { title: '角色创建', hideInBread: false, authCode: '00090302', openMode: 'normal', menuPath: false, },
              },
              {
                path: '/systemManagement/role/edit', name: 'edit', component: resolve => require(['@/views/personal/role/add'], resolve), //edit,
                meta: { title: '角色修改', hideInBread: false, authCode: '00090304', openMode: 'normal', menuPath: false, },
                children: [
                  {
                    path: '/systemManagement/role/look', name: 'look', component: resolve => require(['@/views/personal/role/add'], resolve), //look,
                    meta: { title: '角色查看', hideInBread: false, authCode: '00090301', openMode: 'normal', menuPath: false, }
                  }
                ]
              },
              
            ]
          },
          { //  用户管理
            path: '/systemManagement/people', name: 'people', component: resolve => require(['@/views/personal/InternalStaff/index'], resolve), //people,
            meta: { title: '用户管理', authCode: '000904', menuPath: true, menuIcon: 'setting', hideInBread: false, },
            children: [ 
              {
                path: '/systemManagement/people/info', name: 'staffInfo', component: resolve => require(['@/views/personal/InternalStaff/info'], resolve), //staffInfo,
                meta: { title: '账号详情', hideInBread: false, authCode: '00090401' },
              },
              {
                path: '/systemManagement/people/createStaff', name: 'createStaff', component: resolve => require(['@/views/personal/InternalStaff/edit'], resolve), //createStaff,
                meta: { title: '新增账号', hideInBread: false, authCode: '00090403'},
              },
    
              {
                path: '/systemManagement/people/editStaff', name: 'editStaff', component: resolve => require(['@/views/personal/InternalStaff/edit'], resolve), //editStaff,
                meta: { title: '修改账号', menuPath: true, hideInBread: false, authCode: '00090402'},
                children: [
    
                ]
              },
            ]
          },
          { //  日志管理
            path: '/systemManagement/rizhi', name: 'rizhi', component: resolve => require(['@/views/personal/rizhi/rizhiList'], resolve), //people,
            meta: { title: '日志管理', authCode: '', menuPath: true, menuIcon: 'setting', hideInBread: false, },
            children: [ 
              {
                path: '/systemManagement/rizhi/info', name: 'rizhiInfo', component: resolve => require(['@/views/personal/rizhi/info'], resolve), //staffInfo,
                meta: { title: '日志管理详情', hideInBread: false, authCode: '' },
              },
            ]
          },
        ]
      }, 
      {
        path: '/house', name: 'house', component: resolve => require(['@/components/Layout/content-wrapper'], resolve), // ContentWrapper,
        meta: { title: '住宅信息', menuPath: true, menuIcon: 'profile', hideInBread: true, requirePerm: false, authCode: '0001' },
        children: [ 
          { // 小区列表
            path: '/houseData/basicInfo', name: 'basicInfo', component: resolve => require(['@/views/houseData/basicInfo'], resolve), //basicInfo,
            meta: { title: '小区列表', menuPath: true, hideInBread: false, authCode: '000101' },
            children: [ 
              {
                path: '/houseData/basicInfo/:id', name: 'basicView', component: resolve => require(['@/views/houseData/basicView'], resolve), //BasicView,
                meta: { title: '小区详细情况', hideInBread: false, authCode: '00010101' },
              },
              {
                path: '/houseData/buildings', name: 'buildings', component: resolve => require(['@/views/houseData/buildings'], resolve), //Buildings,
                meta: { title: '门牌栋', hideInBread: false, authCode: '00010103'},
                children: [
                  {
                    path: '/houseData/buildings/:id', name: 'buildingView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                    meta: { title: '门牌栋详情', hideInBread: false, authCode: '00010103'}
                  }
                ]
              },
              {
                path: '/houseData/feeStandard', name: 'feeStandard', component: resolve => require(['@/views/houseData/feeStandard'], resolve), //Buildings,
                meta: { title: '物业收费标准', hideInBread: false, },
              },
    
              {
                path: '/houseData/shebei/:id', name: 'shebei', component: resolve => require(['@/views/houseData/shebei'], resolve), //Shebei,
                meta: { title: '设施设备', menuPath: true, hideInBread: false, authCode: '00010101' },
             
              },
              {
                path: '/houseData/shebeikanyan/:id', name: 'shebeiKanyan', component: resolve => require(['@/views/xuhui/shebeiKanyan'], resolve), //Shebei,
                meta: { title: '设施设备(勘验)', menuPath: true, hideInBread: false, authCode: '00010101' },
          
              },
              
            ]
          },
          {//业委会列表
            path: '/houseData/indCous', name: 'indCous', component: resolve => require(['@/views/houseData/indCous'], resolve), //IndCous,
            meta: { title: '业委会信息列表', menuPath: true, hideInBread: false, authCode: '000102' },
            children: [
              {
                path: '/houseData/indCou/:id', name: 'indCouView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                meta: { title: '业委会详细情况', menuPath: false, hideInBread: false, authCode: '00010201'},
              },
              {
                path: '/houseData/members', name: 'members', component: resolve => require(['@/views/houseData/members'], resolve), //Members,
                meta: { title: '业委会成员列表', hideInBread: false, authCode: '00010202'},
                children: [
                  {
                    path: '/houseData/member/:id', name: 'memberView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                    meta: { title: '业委会成员详情', hideInBread: false, authCode: '00010202'}
                  }
                ]
              },
            ]
          },
          {//物业列表
            path: '/houseData/propertyInfo', name: 'propertyInfo', component: resolve => require(['@/views/houseData/propertyInfo'], resolve), //PropertyInfo,
            meta: { title: '物业企业列表', menuPath: true, hideInBread: false, authCode: '000103' },
            children: [
              {
                path: '/houseData/propertyInfo/:id', name: 'propertyInfoView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                meta: { title: '物业服务企业详细情况', hideInBread: false, authCode: '00010301' }
              }
            ]
          },
          { // 小区管理处
            path: '/houseData/cmDivision', name: 'cmDivision', component: resolve => require(['@/views/houseData/cmDivision'], resolve), //CmDivision,
            meta: { title: '小区管理处列表', menuPath: true, hideInBread: false, authCode: '000104' },
            children: [
              {
                path: '/houseData/cmDivision/:id', name: 'cmDivisionView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                meta: { title: '小区管理处详细情况', menuPath: true, hideInBread: false, authCode: '00010401' }
              }
            ]
          },
          { // 小区经理
            path: '/houseData/managers', name: 'managers', component: resolve => require(['@/views/houseData/managers'], resolve), //Managers,
            meta: { title: '小区经理列表', menuPath: true, hideInBread: false, authCode: '000105'},
            children: [
              {
                path: '/houseData/managers/:id', name: 'managerView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                meta: { title: '小区经理详细情况', menuPath: false, hideInBread: false, authCode: '00010501'}
              },
            ]
          },
          {//居委会列表
            path: '/houseData/neighborhoodCommittees', name: 'neighborhoodCommittees', component: resolve => require(['@/views/houseData/neighborhoodCommittees'], resolve), //neighborhoodCommittees,
            meta: { title: '居委会信息列表', menuPath: true, hideInBread: false, authCode: '000106'},
            children: [
              {
                path: '/houseData/neighborhoodCommittees/:id', name: 'neighborhoodCommitteesView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                meta: { title: '居委会详细情况', menuPath: false, hideInBread: false, authCode: '00010601'},
              },
            ]
          },
        ]
      },
      {
        path: '/noN', name: 'feiju', redirect: { name: 'home' }, component: resolve => require(['@/components/Layout/content-wrapper'], resolve), //ContentWrapper,
        meta: { title: '非居信息', menuPath: true, menuIcon: 'profile', hideInBread: true, authCode: '0002' },
        children: [
          { //   非居列表
            path: '/houseData/nonResidents', name: 'nonResidents', component: resolve => require(['@/views/houseData/nonResidents'], resolve), //NonResidents,
            meta: { title: '非居项目信息列表', menuPath: true, hideInBread: false, authCode: '000201'},
            children: [
              {
                path: '/houseData/nonResident/:id', name: 'nonResidentsView', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                meta: { title: '非居详细情况', menuPath: false, hideInBread: false, authCode: '000201' }
              },
              {
                path: '/houseData/nonBuildingList', name: 'nonBuildingList', component: resolve => require(['@/views/houseData/nonBuildingList'], resolve), //PropertyInfoView,
                meta: { title: '非居门牌幢列表', menuPath: false, hideInBread: false, authCode: '000201' },
                children: [
                  {
                    path: '/houseData/nonBuildingList/nonBuildingInfo/:id', name: 'nonBuildingInfo', component: resolve => require(['@/views/houseData/propertyInfoView'], resolve), //PropertyInfoView,
                    meta: { title: '非居门牌幢详情', menuPath: false, hideInBread: false, authCode: '000201' }
                  }
                ]
              },
            ]
          },
        ]
      },
      
    ],
  },
  {
    path: '/login',
    name: 'login',
    meta: { title: '登录' },
    component: resolve => require(['@/views/login'], resolve), //LoginPage,
  },
  { path: '/networkerr', name: 'networkErr', component: resolve => require(['@/views/errorTips/network'], resolve), //TipsNetworkErr,
    meta: { title: '网络异常', },
  },
  { path: '/demo', name: 'demo', component: resolve => require(['@/views/components/demo'], resolve), //Demo,
    meta: { title: 'demo', },
  },
]

export const routes = [
  ...appRoutes,
]