// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'babel-polyfill'
import Vue from 'vue'
import App from './App'
import store from './store'
import router from './router'
import jscookie from 'js-cookie'
import ajax from '@/server/ajax'
import api from '@/server/api'
import Axios from 'axios'
import common from './util/common'
import {registerMicroApps, start} from 'qiankun'
import {PermissionFilter} from './util/permission-filter.js' // 权限全局方法 v-if="$permission('code')"

import {
  Button,
  message,
  Spin,
  Layout,
  Menu,
  Icon,
  Breadcrumb,
  Form,
  Input,
  InputNumber,
  Card,
  Dropdown,
  Row,
  Col,
  Checkbox,
  Select,
  Alert,
  Table,
  Divider,
  Upload,
  Modal,
  // Tree,
  Tabs,
  DatePicker,
  // skeleton,
  Pagination,
  Tag,
  Badge,
  // TreeSelect,
  Radio,
  Cascader,
  LocaleProvider,
  // Steps,
  Anchor,
  // Collapse,
  Popconfirm,
  Progress,
  // Switch,
  Calendar,
  // BackTop,
  // Carousel,
  Tooltip,
  Tree
  // Progress,
  // CollapsePanel
} from 'ant-design-vue' 

import DetailsItem from '@/components/detail/detailItem'
// import DetailsFile from '@/components/detail/detailFile'

import './assets/base.css' // 引入全局样式
import './assets/reset-ant.css' // 重置ant-design样式

import RouterWapper from '@/components/Layout/content-wrapper'
import GetRoutes from '@/router/getMicRouters'

import ZdyModal from '@/views/components/zdyModal' // 自定义字段修改弹框
import MutSelect from '@/views/components/mutSelect' // 多选框(控制表格展示列)
// import Demo from '@/views/components/demo' // 多选框(控制表格展示列)
import tableAndMut from '@/views/components/tableAndMut' // 多选框(控制表格展示列)
import BatchOperation from '@/views/components/BatchOperation' // 多选框(控制表格展示列)

import micSystemsList from '@/router/micSystemsList.json'

// 由于日期组件默认是英文的，需要本地化
import moment from 'moment'
import 'moment/locale/zh-cn'
moment.locale('zh-cn')  

Vue.component('tableAndMut', tableAndMut)
Vue.component('ZdyModal', ZdyModal)
Vue.component('MutSelect', MutSelect)
Vue.component('BatchOperation', BatchOperation)

Vue.component('DetailsItem', DetailsItem)
// Vue.component('DetailsFile', DetailsFile)
Vue.component('RouterWapper', RouterWapper)

Vue.use(router) 

Vue.use(Button)
Vue.use(Spin)
Vue.use(Layout)
Vue.use(Menu)
Vue.use(Icon)
Vue.use(Breadcrumb)
Vue.use(Form)
Vue.use(Input)
Vue.use(InputNumber)
Vue.use(Card)
Vue.use(Dropdown)
Vue.use(Row)
Vue.use(Col)
Vue.use(Checkbox)
Vue.use(Select)
Vue.use(Alert)
Vue.use(Table)
Vue.use(Divider)
Vue.use(Upload)
Vue.use(Modal)
Vue.use(Progress)
Vue.use(Tree)
// Vue.use(badge)
// Vue.use(skeleton)
// Vue.use(Tree)
Vue.use(Tabs)
Vue.use(DatePicker)
Vue.use(Pagination)
Vue.use(Tag)
Vue.use(Badge)
// Vue.use(TreeSelect)
Vue.use(Radio)
Vue.use(Cascader)
Vue.use(LocaleProvider)
// Vue.use(Steps)
Vue.use(Anchor)
// Vue.use(Collapse)
Vue.use(Popconfirm)
Vue.use(Progress)
// Vue.use(Switch)
Vue.use(Calendar)
// Vue.use(BackTop)
// Vue.use(Carousel)
Vue.use(Tooltip)

Vue.config.productionTip = false
Vue.prototype.$ajax = ajax
Vue.prototype.$api = api
Vue.prototype.$cookie = jscookie
Vue.prototype.$com = common
Vue.prototype.$permission = PermissionFilter
Vue.prototype.$message = message

Vue.prototype.$modal = Modal
Vue.prototype.$store = store
Vue.prototype.$moment = moment 

Vue.directive('title', {
  inserted: function (el) {
    document.title = el.dataset.title
  }
})

/* eslint-disable no-new */
let app = null
const checkPrefix = (prefix) => { // 检查路径前缀
  return location => location.pathname.startsWith(prefix)
}
const render = ({appContent, loading} = {}) => { // 渲染方法
  
  if (!app) {
    GetRoutes(router)
    app = new Vue({
      el: '#portal',
      store,
      router,
      data() {
        return {
          content: appContent,
          loading,
        }
      },
      render(h) {
        return h(App, {
          props: {
            content: this.content,
            loading: this.loading,
          }
        })
      }
    })
  } else {
    app.content = appContent
    app.loading = loading
  }
}

// 动态加载子项目的url
let system //= micSystemsList
let env = process.env.NODE_ENV

console.log(process.env.NODE_ENV, 'NODE_ENV')
switch (env) {
// case env.indexOf('pudong') > -1: // 根据当前打包的项目调用该项目对应的路由
case 'sit':
  system = micSystemsList.sit
  break
case 'production':
  system = micSystemsList.prod
  break
  
case 'pudong-sit':
  system = micSystemsList.sit
  break
    
case 'pudong-prod':
  system = micSystemsList.prod
  break
  
  // case env.indexOf('xuhui') > -1:
case 'xuhui-sit':
  system = micSystemsList.sit
  break
  
case 'xuhui-prod':
  system = micSystemsList.prod
  break

case 'huangpu-sit':
  system = micSystemsList.sit
  break
  
case 'huangpu-prod':
  system = micSystemsList.prod
  break

case 'yangpu-sit':
  system = micSystemsList.sit
  break
  
case 'yangpu-prod':
  system = micSystemsList.prod
  break
      
default: // 当前仅可使用pudong / xuhui-sit/uat进行打包
  system = micSystemsList.sit
  break
}

let projects = []
for (let i = 0; i < system.length; i++) { 
  projects.push({
    name: system[i].name,
    entry: system[i].entry,
    render,
    activeRule: checkPrefix(system[i].activeRule)
  }) 
}
registerMicroApps(projects) // 注册子项目

render()

start()
