/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.surefire.common.junit4.JUnit4ProviderUtil;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.common.junit4.JUnitTestFailureListener;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.SelectorUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4Provider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final List<RunListener> customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private final String requestedTestMethod;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;
    private final ScanResult scanResult;
    private final int rerunFailingTestsCount;
    private TestsToRun testsToRun;

    public JUnit4Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.scanResult = booterParameters.getScanResult();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners(booterParameters.getProviderProperties().getProperty("listener"));
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
        this.requestedTestMethod = booterParameters.getTestRequest().getRequestedTestMethod();
        this.rerunFailingTestsCount = booterParameters.getTestRequest().getRerunFailingTestsCount();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.scanClassPath());
        }
        this.upgradeCheck();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        org.apache.maven.surefire.report.RunListener reporter = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        JUnit4RunListener jUnit4TestSetReporter = new JUnit4RunListener(reporter);
        Result result = new Result();
        RunNotifier runNotifier = this.getRunNotifier(jUnit4TestSetReporter, result, this.customRunListeners);
        runNotifier.fireTestRunStarted(this.createTestsDescription());
        for (Class aTestsToRun : this.testsToRun) {
            this.executeTestSet(aTestsToRun, reporter, runNotifier);
        }
        runNotifier.fireTestRunFinished(result);
        JUnit4RunListener.rethrowAnyTestMechanismFailures(result);
        this.closeRunNotifier(jUnit4TestSetReporter, this.customRunListeners);
        return reporterFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class<?> clazz, org.apache.maven.surefire.report.RunListener reporter, RunNotifier listeners) {
        SimpleReportEntry report = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), clazz.getName());
        reporter.testSetStarting((ReportEntry)report);
        try {
            if (!StringUtils.isBlank((String)this.requestedTestMethod)) {
                String actualTestMethod = JUnit4Provider.getMethod(clazz, this.requestedTestMethod);
                String[] testMethods = StringUtils.split((String)actualTestMethod, (String)"+");
                this.executeWithRerun(clazz, listeners, testMethods);
            } else {
                this.executeWithRerun(clazz, listeners, null);
            }
        }
        catch (Throwable e) {
            reporter.testError((ReportEntry)SimpleReportEntry.withException((String)report.getSourceName(), (String)report.getName(), (StackTraceWriter)new PojoStackTraceWriter(report.getSourceName(), report.getName(), e)));
        }
        finally {
            reporter.testSetCompleted((ReportEntry)report);
        }
    }

    private void executeWithRerun(Class<?> clazz, RunNotifier listeners, String[] testMethods) {
        JUnitTestFailureListener failureListener = new JUnitTestFailureListener();
        listeners.addListener((RunListener)failureListener);
        JUnit4Provider.execute(clazz, listeners, testMethods);
        if (this.rerunFailingTestsCount > 0) {
            for (int i = 0; i < this.rerunFailingTestsCount && !failureListener.getAllFailures().isEmpty(); ++i) {
                Set<String> methodsSet = JUnit4ProviderUtil.generateFailingTests(failureListener.getAllFailures());
                String[] methods = methodsSet.toArray(new String[methodsSet.size()]);
                failureListener.reset();
                JUnit4Provider.execute(clazz, listeners, methods);
            }
        }
    }

    private RunNotifier getRunNotifier(RunListener main, Result result, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.addListener(main);
        fNotifier.addListener(result.createListener());
        for (RunListener listener : others) {
            fNotifier.addListener(listener);
        }
        return fNotifier;
    }

    private void closeRunNotifier(RunListener main, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.removeListener(main);
        for (RunListener listener : others) {
            fNotifier.removeListener(listener);
        }
    }

    public Iterator<?> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    private TestsToRun scanClassPath() {
        TestsToRun scannedClasses = this.scanResult.applyFilter((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scannedClasses);
    }

    private void upgradeCheck() throws TestSetFailedException {
        List classesSkippedByValidation;
        if (JUnit4Provider.isJUnit4UpgradeCheck() && !(classesSkippedByValidation = this.scanResult.getClassesSkippedByValidation((ScannerFilter)this.jUnit4TestChecker, this.testClassLoader)).isEmpty()) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : classesSkippedByValidation) {
                reason.append("   ");
                reason.append(testClass.getName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    private Description createTestsDescription() {
        ArrayList classes = new ArrayList();
        for (Class clazz : this.testsToRun) {
            classes.add(clazz);
        }
        return JUnit4ProviderUtil.createSuiteDescription(classes);
    }

    private static boolean isJUnit4UpgradeCheck() {
        return System.getProperty("surefire.junit4.upgradecheck") != null;
    }

    private static void execute(Class<?> testClass, RunNotifier fNotifier, String[] testMethods) {
        if (testMethods != null) {
            for (Method method : testClass.getMethods()) {
                for (String testMethod : testMethods) {
                    if (!SelectorUtils.match(testMethod, method.getName())) continue;
                    Request.method(testClass, (String)method.getName()).getRunner().run(fNotifier);
                }
            }
        } else {
            Request.aClass(testClass).getRunner().run(fNotifier);
        }
    }

    private static String getMethod(Class testClass, String testMethodStr) {
        int endIndex;
        int beginIndex;
        String className = testClass.getName();
        if (!testMethodStr.contains("#") && !testMethodStr.contains(",")) {
            return testMethodStr;
        }
        String classMethodStr = (testMethodStr = testMethodStr + ",").substring(beginIndex = testMethodStr.indexOf(className), endIndex = testMethodStr.indexOf(",", beginIndex));
        int index = classMethodStr.indexOf(35);
        return index >= 0 ? classMethodStr.substring(index + 1, classMethodStr.length()) : null;
    }
}

