/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.usability.plugin.Expression;
import org.apache.maven.usability.plugin.ExpressionDocumentationException;
import org.apache.maven.usability.plugin.ExpressionDocumenter;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="expressions", requiresProject=false)
public class ExpressionsMojo
extends AbstractHelpMojo {
    private static final String NO_DESCRIPTION_AVAILABLE = "No description available.";

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map m;
        try {
            m = ExpressionDocumenter.load();
        }
        catch (ExpressionDocumentationException e) {
            throw new MojoExecutionException("ExpressionDocumentationException: " + e.getMessage(), (Exception)((Object)e));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Maven supports the following Plugin expressions:\n\n");
        for (String string : ExpressionsMojo.getExpressionsRoot()) {
            sb.append("${").append(string).append("}: ");
            sb.append(NO_DESCRIPTION_AVAILABLE);
            sb.append("\n\n");
        }
        for (Map.Entry entry : m.entrySet()) {
            String key = (String)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            sb.append("${").append(key).append("}: ");
            sb.append(ExpressionsMojo.trimCDATA(expression.getDescription()));
            sb.append("\n\n");
        }
        if (this.output != null) {
            try {
                ExpressionsMojo.writeFile(this.output, sb);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write plugins expressions description to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Wrote descriptions to: " + this.output));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static List<String> getExpressionsRoot() throws MojoFailureException, MojoExecutionException {
        try {
            Field f = ExpressionDocumenter.class.getDeclaredField("EXPRESSION_ROOTS");
            f.setAccessible(true);
            String[] value = (String[])f.get(new ExpressionDocumenter());
            if (value == null) {
                throw new MojoExecutionException("org.apache.maven.usability.plugin.ExpressionDocumenter#EXPRESSION_ROOTS has no value.");
            }
            return Arrays.asList(value);
        }
        catch (SecurityException e) {
            throw new MojoFailureException("SecurityException: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("IllegalArgumentException: " + e.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new MojoFailureException("NoSuchFieldException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MojoFailureException("IllegalAccessException: " + e.getMessage());
        }
    }

    private static String trimCDATA(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return NO_DESCRIPTION_AVAILABLE;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = StringUtils.split((String)description, (String)"\r\n");
        for (int i = 0; i < lines.length; ++i) {
            sb.append(StringUtils.trim((String)lines[i])).append(" ");
        }
        return sb.toString();
    }
}

