/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="get", requiresProject=false, threadSafe=true)
public class GetMojo
extends AbstractMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Component
    private ArtifactMetadataSource source;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="repoId", defaultValue="temp")
    private String repositoryId = "temp";
    @Parameter(property="repoUrl")
    private String repositoryUrl;
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(property="dest")
    private String destination;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="transitive", defaultValue="true")
    private boolean transitive = true;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (this.artifactId == null && this.artifact == null) {
            throw new MojoFailureException("You must specify an artifact, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0");
        }
        if (this.artifact != null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging][:classifier] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length >= 4) {
                this.packaging = tokens[3];
            }
            this.classifier = tokens.length == 5 ? tokens[4] : null;
        }
        Artifact toDownload = this.classifier == null ? this.artifactFactory.createBuildArtifact(this.groupId, this.artifactId, this.version, this.packaging) : this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        Artifact dummyOriginatingArtifact = this.artifactFactory.createBuildArtifact("org.apache.maven.plugins", "maven-downloader-plugin", "1.0", "jar");
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
        if (this.pomRemoteRepositories != null) {
            repoList.addAll(this.pomRemoteRepositories);
        }
        if (this.remoteRepositories != null) {
            List<String> repos = Arrays.asList(StringUtils.split((String)this.remoteRepositories, (String)","));
            for (String repo : repos) {
                repoList.add(this.parseRepository(repo, always));
            }
        }
        if (this.repositoryUrl != null) {
            this.getLog().warn((CharSequence)"repositoryUrl parameter is deprecated. Use remoteRepositories instead");
            ArtifactRepository remoteRepo = this.artifactRepositoryFactory.createArtifactRepository(this.repositoryId, this.repositoryUrl, this.getLayout("default"), always, always);
            repoList.add(remoteRepo);
        }
        try {
            if (this.transitive) {
                this.getLog().info((CharSequence)("Resolving " + toDownload + " with transitive dependencies"));
                this.artifactResolver.resolveTransitively(Collections.singleton(toDownload), dummyOriginatingArtifact, repoList, this.localRepository, this.source);
            } else {
                this.getLog().info((CharSequence)("Resolving " + toDownload));
                this.artifactResolver.resolve(toDownload, repoList, this.localRepository);
            }
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.destination != null) {
            this.getLog().warn((CharSequence)"destination/dest parameter is deprecated: it will disappear in future version.");
            File src = toDownload.getFile();
            File dest = new File(this.destination);
            this.getLog().info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + dest.getAbsolutePath()));
            if (this.transitive) {
                this.getLog().warn((CharSequence)"Notice transitive dependencies won't be copied.");
            }
            try {
                if (dest.isDirectory()) {
                    FileUtils.copyFileToDirectory((File)src, (File)dest);
                } else {
                    FileUtils.copyFile((File)src, (File)dest);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Couldn't copy downloaded artifact from " + src.getAbsolutePath() + " to " + dest.getAbsolutePath() + " : " + e.getMessage(), (Exception)e);
            }
        }
    }

    ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = this.repositoryId;
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return this.artifactRepositoryFactory.createArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

