/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.privilegedactions.GetConstraintValidatorList;
import org.hibernate.validator.spi.constraintdefinition.ConstraintDefinitionContributor;

public class ServiceLoaderBasedConstraintDefinitionContributor
implements ConstraintDefinitionContributor {
    private final TypeResolutionHelper typeResolutionHelper;

    public ServiceLoaderBasedConstraintDefinitionContributor(TypeResolutionHelper typeResolutionHelper) {
        this.typeResolutionHelper = typeResolutionHelper;
    }

    @Override
    public void collectConstraintDefinitions(ConstraintDefinitionContributor.ConstraintDefinitionBuilder constraintDefinitionContributionBuilder) {
        HashMap customValidators = CollectionHelper.newHashMap();
        GetConstraintValidatorList constraintValidatorListAction = new GetConstraintValidatorList();
        List discoveredConstraintValidators = (List)this.run(constraintValidatorListAction);
        for (ConstraintValidator constraintValidator : discoveredConstraintValidators) {
            Class<?> constraintValidatorClass = constraintValidator.getClass();
            Class<?> annotationType = this.determineAnnotationType(constraintValidatorClass);
            ArrayList validators = (ArrayList)customValidators.get(annotationType);
            if (annotationType != null && validators == null) {
                validators = new ArrayList();
                customValidators.put(annotationType, validators);
            }
            validators.add(constraintValidatorClass);
        }
        for (Map.Entry entry : customValidators.entrySet()) {
            this.registerConstraintDefinition(constraintDefinitionContributionBuilder, (Class)entry.getKey(), (List)entry.getValue());
        }
    }

    private <A extends Annotation> void registerConstraintDefinition(ConstraintDefinitionContributor.ConstraintDefinitionBuilder builder, Class<?> constraintType, List<Class<?>> validatorTypes) {
        ConstraintDefinitionContributor.ConstraintDefinitionBuilderContext<?> context = builder.constraint(constraintType).includeExistingValidators(true);
        for (Class<?> validatorType : validatorTypes) {
            context.validatedBy(validatorType);
        }
    }

    private Class<?> determineAnnotationType(Class<?> constraintValidatorClass) {
        ResolvedType resolvedType = this.typeResolutionHelper.getTypeResolver().resolve(constraintValidatorClass, new Type[0]);
        return ((ResolvedType)resolvedType.typeParametersFor(ConstraintValidator.class).get(0)).getErasedType();
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

