/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import org.sonarsource.scanner.api.internal.ClassloadRules;
import org.sonarsource.scanner.api.internal.IsolatedClassloader;
import org.sonarsource.scanner.api.internal.IsolatedLauncherProxy;
import org.sonarsource.scanner.api.internal.JarDownloader;
import org.sonarsource.scanner.api.internal.JarDownloaderFactory;
import org.sonarsource.scanner.api.internal.ScannerException;
import org.sonarsource.scanner.api.internal.ServerConnection;
import org.sonarsource.scanner.api.internal.SimulatedLauncher;
import org.sonarsource.scanner.api.internal.TempCleaning;
import org.sonarsource.scanner.api.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.api.internal.cache.Logger;

public class IsolatedLauncherFactory
implements Closeable {
    static final String ISOLATED_LAUNCHER_IMPL = "org.sonarsource.scanner.api.internal.batch.BatchIsolatedLauncher";
    private final TempCleaning tempCleaning;
    private final String launcherImplClassName;
    private final Logger logger;
    private IsolatedClassloader cl;

    IsolatedLauncherFactory(String isolatedLauncherClassName, TempCleaning tempCleaning, Logger logger) {
        this.tempCleaning = tempCleaning;
        this.launcherImplClassName = isolatedLauncherClassName;
        this.logger = logger;
    }

    public IsolatedLauncherFactory(Logger logger) {
        this(ISOLATED_LAUNCHER_IMPL, new TempCleaning(logger), logger);
    }

    private IsolatedClassloader createClassLoader(List<File> jarFiles, ClassloadRules maskRules) {
        IsolatedClassloader classloader = new IsolatedClassloader(this.getClass().getClassLoader(), maskRules);
        classloader.addFiles(jarFiles);
        return classloader;
    }

    public IsolatedLauncher createLauncher(Map<String, String> props, ClassloadRules rules) {
        if (props.containsKey("sonar.scanner.dumpToFile")) {
            String version = props.get("sonar.scanner.versionSimulation");
            if (version == null) {
                version = "5.6";
            }
            return new SimulatedLauncher(version, this.logger);
        }
        ServerConnection serverConnection = ServerConnection.create(props, this.logger);
        JarDownloader jarDownloader = new JarDownloaderFactory(serverConnection, this.logger, props.get("sonar.userHome")).create();
        return this.createLauncher(jarDownloader, rules);
    }

    IsolatedLauncher createLauncher(JarDownloader jarDownloader, ClassloadRules rules) {
        return AccessController.doPrivileged(() -> {
            try {
                List<File> jarFiles = jarDownloader.download();
                this.logger.debug("Create isolated classloader...");
                this.cl = this.createClassLoader(jarFiles, rules);
                IsolatedLauncher objProxy = IsolatedLauncherProxy.create((ClassLoader)this.cl, IsolatedLauncher.class, this.launcherImplClassName, this.logger);
                this.tempCleaning.clean();
                return objProxy;
            }
            catch (Exception e) {
                throw new ScannerException("Unable to execute SonarQube", e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.cl != null) {
            this.cl.close();
        }
    }
}

