/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractMavenReport
extends AbstractMojo
implements MavenMultiPageReport {
    private Sink sink;
    private SinkFactory sinkFactory;
    private File reportOutputDirectory;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            File outputDirectory = new File(this.getOutputDirectory());
            String filename = this.getOutputName() + ".html";
            Locale locale = Locale.getDefault();
            SiteRenderingContext siteContext = new SiteRenderingContext();
            siteContext.setDecoration(new DecorationModel());
            siteContext.setTemplateName("org/apache/maven/doxia/siterenderer/resources/default-site.vm");
            siteContext.setLocale(locale);
            RenderingContext context = new RenderingContext(outputDirectory, filename);
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, null, locale);
            outputDirectory.mkdirs();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDirectory, filename)), "UTF-8");
            this.getSiteRenderer().generateDocument((Writer)writer, sink, siteContext);
        }
        catch (RendererException e) {
            try {
                throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e2);
                }
                catch (MavenReportException e3) {
                    throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public void generate(org.codehaus.doxia.sink.Sink aSink, Locale aLocale) throws MavenReportException {
        this.getLog().warn((CharSequence)"Deprecated API called - not org.apache.maven.doxia.sink.Sink instance and no SinkFactory available. Please update this plugin.");
        this.generate((Sink)aSink, null, aLocale);
    }

    public void generate(Sink aSink, Locale aLocale) throws MavenReportException {
        this.getLog().warn((CharSequence)"Deprecated API called - no SinkFactory available. Please update this plugin.");
        this.generate(aSink, null, aLocale);
    }

    public void generate(Sink aSink, SinkFactory aSinkFactory, Locale aLocale) throws MavenReportException {
        if (aSink == null) {
            throw new MavenReportException("You must specify a sink.");
        }
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"This report cannot be generated as part of the current build. The report name should be referenced in this line of output.");
            return;
        }
        this.sink = aSink;
        this.sinkFactory = aSinkFactory;
        this.executeReport(aLocale);
        this.closeReport();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    protected void closeReport() {
        this.getSink().close();
    }

    public Sink getSink() {
        return this.sink;
    }

    public SinkFactory getSinkFactory() {
        return this.sinkFactory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    protected abstract Renderer getSiteRenderer();

    protected abstract String getOutputDirectory();

    protected abstract MavenProject getProject();

    protected abstract void executeReport(Locale var1) throws MavenReportException;
}

