/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.orm.jpa.DataSourceInitializedPublisher;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@EnableConfigurationProperties(value={JpaProperties.class})
@Import(value={DataSourceInitializedPublisher.Registrar.class})
public abstract class JpaBaseConfiguration
implements BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(JpaBaseConfiguration.class);
    private final DataSource dataSource;
    private final JpaProperties properties;
    private final JtaTransactionManager jtaTransactionManager;
    private ConfigurableListableBeanFactory beanFactory;

    protected JpaBaseConfiguration(DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManagerProvider) {
        this.dataSource = dataSource;
        this.properties = properties;
        this.jtaTransactionManager = (JtaTransactionManager)jtaTransactionManagerProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(value={PlatformTransactionManager.class})
    public PlatformTransactionManager transactionManager() {
        return new JpaTransactionManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaVendorAdapter jpaVendorAdapter() {
        AbstractJpaVendorAdapter adapter = this.createJpaVendorAdapter();
        adapter.setShowSql(this.properties.isShowSql());
        adapter.setDatabase(this.properties.getDatabase());
        adapter.setDatabasePlatform(this.properties.getDatabasePlatform());
        adapter.setGenerateDdl(this.properties.isGenerateDdl());
        return adapter;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, ObjectProvider<PersistenceUnitManager> persistenceUnitManagerProvider) {
        EntityManagerFactoryBuilder builder = new EntityManagerFactoryBuilder(jpaVendorAdapter, this.properties.getProperties(), (PersistenceUnitManager)persistenceUnitManagerProvider.getIfAvailable(), this.determinePersistenceUnitRootLocation());
        builder.setCallback(this.getVendorCallback());
        return builder;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={LocalContainerEntityManagerFactoryBean.class, EntityManagerFactory.class})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder factoryBuilder) {
        Map<String, Object> vendorProperties = this.getVendorProperties();
        this.customizeVendorProperties(vendorProperties);
        return factoryBuilder.dataSource(this.dataSource).packages(this.getPackagesToScan()).properties(vendorProperties).jta(this.isJta()).build();
    }

    protected abstract AbstractJpaVendorAdapter createJpaVendorAdapter();

    protected abstract Map<String, Object> getVendorProperties();

    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
    }

    protected EntityManagerFactoryBuilder.EntityManagerFactoryBeanCallback getVendorCallback() {
        return null;
    }

    protected String[] getPackagesToScan() {
        List<String> packages = EntityScanPackages.get((BeanFactory)this.beanFactory).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
            packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        }
        return packages.toArray(new String[packages.size()]);
    }

    protected JtaTransactionManager getJtaTransactionManager() {
        return this.jtaTransactionManager;
    }

    protected final boolean isJta() {
        return this.jtaTransactionManager != null;
    }

    protected final JpaProperties getProperties() {
        return this.properties;
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    private URL determinePersistenceUnitRootLocation() {
        Class<?> source = this.getClass();
        try {
            URL url = source.getProtectionDomain().getCodeSource().getLocation();
            return ResourceUtils.extractJarFileURL((URL)url);
        }
        catch (Exception ex) {
            logger.info((Object)("Could not determine persistence unit root location from " + source + " : " + ex));
            return null;
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={WebMvcConfigurerAdapter.class})
    @ConditionalOnMissingBean(value={OpenEntityManagerInViewInterceptor.class, OpenEntityManagerInViewFilter.class})
    @ConditionalOnProperty(prefix="spring.jpa", name={"open-in-view"}, havingValue="true", matchIfMissing=true)
    protected static class JpaWebConfiguration {
        protected JpaWebConfiguration() {
        }

        @Configuration
        protected static class JpaWebMvcConfiguration
        extends WebMvcConfigurerAdapter {
            protected JpaWebMvcConfiguration() {
            }

            @Bean
            public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
                return new OpenEntityManagerInViewInterceptor();
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addWebRequestInterceptor((WebRequestInterceptor)this.openEntityManagerInViewInterceptor());
            }
        }
    }
}

