/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.util.List;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.codehaus.plexus.logging.Logger;

public final class TypeConversionUtils {
    private static final int U_R = 256;
    private static final int U_W = 128;
    private static final int U_X = 64;
    private static final int G_R = 32;
    private static final int G_W = 16;
    private static final int G_X = 8;
    private static final int W_R = 4;
    private static final int W_W = 2;
    private static final int W_X = 1;

    private TypeConversionUtils() {
    }

    public static String[] toStringArray(List<String> list) {
        String[] result = null;
        if (list != null && !list.isEmpty()) {
            result = list.toArray(new String[list.size()]);
        }
        return result;
    }

    public static int modeToInt(String mode, Logger logger) throws AssemblyFormattingException {
        if (mode == null || mode.trim().length() < 1) {
            return -1;
        }
        try {
            int value = Integer.parseInt(mode, 8);
            TypeConversionUtils.verifyModeSanity(value, logger);
            return value;
        }
        catch (NumberFormatException e) {
            throw new AssemblyFormattingException("Failed to parse mode as an octal number: '" + mode + "'.", e);
        }
    }

    public static boolean verifyModeSanity(int mode, Logger logger) {
        StringBuilder messages = new StringBuilder();
        messages.append("The mode: ").append(Integer.toString(mode, 8)).append(" contains nonsensical permissions:");
        boolean warn = false;
        if ((mode & 0x100) == 0 && (mode & 0x20) == 32) {
            messages.append("\n- Group has read access, but user does not.");
            warn = true;
        }
        if ((mode & 0x100) == 0 && (mode & 4) == 4) {
            messages.append("\n- World has read access, but user does not.");
            warn = true;
        }
        if ((mode & 0x20) == 0 && (mode & 4) == 4) {
            messages.append("\n- World has read access, but group does not.");
            warn = true;
        }
        if ((mode & 0x80) == 0 && (mode & 0x10) == 16) {
            messages.append("\n- Group has write access, but user does not.");
            warn = true;
        }
        if ((mode & 0x80) == 0 && (mode & 2) == 2) {
            messages.append("\n- World has write access, but user does not.");
            warn = true;
        }
        if ((mode & 0x10) == 0 && (mode & 2) == 2) {
            messages.append("\n- World has write access, but group does not.");
            warn = true;
        }
        if ((mode & 0x40) == 0 && (mode & 8) == 8) {
            messages.append("\n- Group has execute/list access, but user does not.");
            warn = true;
        }
        if ((mode & 0x40) == 0 && (mode & 1) == 1) {
            messages.append("\n- World has execute/list access, but user does not.");
            warn = true;
        }
        if ((mode & 8) == 0 && (mode & 1) == 1) {
            messages.append("\n- World has execute/list access, but group does not.");
            warn = true;
        }
        if (warn) {
            logger.warn(messages.toString());
        }
        return !warn;
    }
}

