/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.booterclient.ProviderDetector;
import org.apache.maven.surefire.providerapi.SurefireProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderList {
    private final ProviderInfo[] wellKnownProviders;
    private final ConfigurableProviderInfo dynamicProvider;

    public ProviderList(ConfigurableProviderInfo dynamicProviderInfo, ProviderInfo ... wellKnownProviders) {
        this.wellKnownProviders = wellKnownProviders;
        this.dynamicProvider = dynamicProviderInfo;
    }

    @Nonnull
    public List<ProviderInfo> resolve(@Nonnull Log log) {
        ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
        Set<String> manuallyConfiguredProviders = this.getManuallyConfiguredProviders();
        if (manuallyConfiguredProviders.size() > 0) {
            for (String name : manuallyConfiguredProviders) {
                ProviderInfo wellKnown = this.findByName(name);
                ProviderInfo providerToAdd = wellKnown != null ? wellKnown : this.dynamicProvider.instantiate(name);
                log.info((CharSequence)("Using configured provider " + providerToAdd.getProviderName()));
                providersToRun.add(providerToAdd);
            }
            return providersToRun;
        }
        return this.autoDetectOneProvider();
    }

    @Nonnull
    private List<ProviderInfo> autoDetectOneProvider() {
        ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
        for (ProviderInfo wellKnownProvider : this.wellKnownProviders) {
            if (!wellKnownProvider.isApplicable()) continue;
            providersToRun.add(wellKnownProvider);
            return providersToRun;
        }
        return providersToRun;
    }

    private Set<String> getManuallyConfiguredProviders() {
        try {
            return ProviderDetector.getServiceNames(SurefireProvider.class, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ProviderInfo findByName(String providerClassName) {
        for (ProviderInfo wellKnownProvider : this.wellKnownProviders) {
            if (!wellKnownProvider.getProviderName().equals(providerClassName)) continue;
            return wellKnownProvider;
        }
        return null;
    }
}

