/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.JdbcSessionDatabaseInitializer;
import org.springframework.boot.autoconfigure.session.SessionCondition;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@Conditional(value={SessionCondition.class})
class JdbcSessionConfiguration {
    JdbcSessionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public JdbcSessionDatabaseInitializer jdbcSessionDatabaseInitializer(SessionProperties properties, DataSource dataSource, ResourceLoader resourceLoader) {
        return new JdbcSessionDatabaseInitializer(properties, dataSource, resourceLoader);
    }

    @Configuration
    public static class SpringBootJdbcHttpSessionConfiguration
    extends JdbcHttpSessionConfiguration {
        @Autowired
        public void customize(SessionProperties sessionProperties) {
            Integer timeout = sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds(timeout);
            }
            this.setTableName(sessionProperties.getJdbc().getTableName());
        }
    }
}

