/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.ClassUtils;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                if (!propertySource.containsProperty(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    @Override
    protected String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    protected <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Object value;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)String.format("Searching for key '%s' in [%s]", key, propertySource.getName()));
                }
                if ((value = propertySource.getProperty(key)) == null) continue;
                if (resolveNestedPlaceholders && value instanceof String) {
                    value = this.resolveNestedPlaceholders((String)value);
                }
                this.logKeyFound(key, propertySource, value);
                return this.conversionService.convert(value, targetValueType);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Could not find key '%s' in any property source", key));
        }
        return null;
    }

    @Override
    @Deprecated
    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetValueType) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Class<?> clazz;
                Object value;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)String.format("Searching for key '%s' in [%s]", key, propertySource.getName()));
                }
                if ((value = propertySource.getProperty(key)) == null) continue;
                this.logKeyFound(key, propertySource, value);
                if (value instanceof String) {
                    try {
                        clazz = ClassUtils.forName((String)value, null);
                    }
                    catch (Exception ex) {
                        throw new ClassConversionException((String)value, targetValueType, ex);
                    }
                } else {
                    clazz = value instanceof Class ? (Class<?>)value : value.getClass();
                }
                if (!targetValueType.isAssignableFrom(clazz)) {
                    throw new ClassConversionException(clazz, targetValueType);
                }
                Class<?> targetClass = clazz;
                return targetClass;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Could not find key '%s' in any property source", key));
        }
        return null;
    }

    protected void logKeyFound(String key, PropertySource<?> propertySource, Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Found key '%s' in [%s] with type [%s]", key, propertySource.getName(), value.getClass().getSimpleName()));
        }
    }

    @Deprecated
    private static class ClassConversionException
    extends ConversionException {
        public ClassConversionException(Class<?> actual, Class<?> expected) {
            super(String.format("Actual type %s is not assignable to expected type %s", actual.getName(), expected.getName()));
        }

        public ClassConversionException(String actual, Class<?> expected, Exception ex) {
            super(String.format("Could not find/load class %s during attempt to convert to %s", actual, expected.getName()), ex);
        }
    }
}

