/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;

public class ExceptionCatcher
extends ActionCommandBase
implements Filter {
    private static final Log LOG = LogFactory.getLog((Class)ExceptionCatcher.class);
    private String catalogName = null;
    private String exceptionCommand = null;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getExceptionCommand() {
        return this.exceptionCommand;
    }

    public void setExceptionCommand(String exceptionCommand) {
        this.exceptionCommand = exceptionCommand;
    }

    public boolean execute(ActionContext actionCtx) throws Exception {
        actionCtx.setException(null);
        return false;
    }

    public boolean postprocess(Context context, Exception exception) {
        if (exception == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Attempting to handle a thrown exception");
        }
        ActionContext actionCtx = (ActionContext)context;
        actionCtx.setException(exception);
        try {
            Command command = this.lookupExceptionCommand();
            if (command == null) {
                LOG.error((Object)("Cannot find exceptionCommand '" + this.exceptionCommand + "'"));
                throw new IllegalStateException("Cannot find exceptionCommand '" + this.exceptionCommand + "'");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Calling exceptionCommand '" + this.exceptionCommand + "'"));
            }
            command.execute(context);
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception from exceptionCommand '" + this.exceptionCommand + "'"), (Throwable)e);
            throw new IllegalStateException("Exception chain threw exception");
        }
        return true;
    }

    protected Command lookupExceptionCommand() {
        String exceptionCommand;
        Catalog catalog;
        String catalogName = this.getCatalogName();
        if (catalogName == null) {
            catalog = CatalogFactory.getInstance().getCatalog();
            if (catalog == null) {
                LOG.error((Object)"Cannot find default catalog");
                throw new IllegalArgumentException("Cannot find default catalog");
            }
        } else {
            catalog = CatalogFactory.getInstance().getCatalog(catalogName);
            if (catalog == null) {
                LOG.error((Object)("Cannot find catalog '" + catalogName + "'"));
                throw new IllegalArgumentException("Cannot find catalog '" + catalogName + "'");
            }
        }
        if ((exceptionCommand = this.getExceptionCommand()) == null) {
            LOG.error((Object)"No exceptionCommand property specified");
            throw new IllegalStateException("No exceptionCommand property specfied");
        }
        return catalog.getCommand(exceptionCommand);
    }
}

