/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template;

import groovy.text.markup.MarkupTemplateEngine;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateProperties;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfig;
import org.springframework.web.servlet.view.groovy.GroovyMarkupConfigurer;
import org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver;

@Configuration
@ConditionalOnClass(value={MarkupTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={GroovyTemplateProperties.class})
public class GroovyTemplateAutoConfiguration {
    private static final Log logger = LogFactory.getLog(GroovyTemplateAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={Servlet.class, LocaleContextHolder.class, UrlBasedViewResolver.class})
    @ConditionalOnWebApplication
    @ConditionalOnProperty(name={"spring.groovy.template.enabled"}, matchIfMissing=true)
    public static class GroovyWebConfiguration {
        private final GroovyTemplateProperties properties;

        public GroovyWebConfiguration(GroovyTemplateProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(name={"groovyMarkupViewResolver"})
        public GroovyMarkupViewResolver groovyMarkupViewResolver() {
            GroovyMarkupViewResolver resolver = new GroovyMarkupViewResolver();
            this.properties.applyToViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnClass(value={GroovyMarkupConfigurer.class})
    public static class GroovyMarkupConfiguration {
        private final ApplicationContext applicationContext;
        private final GroovyTemplateProperties properties;
        private final MarkupTemplateEngine templateEngine;

        public GroovyMarkupConfiguration(ApplicationContext applicationContext, GroovyTemplateProperties properties, ObjectProvider<MarkupTemplateEngine> templateEngineProvider) {
            this.applicationContext = applicationContext;
            this.properties = properties;
            this.templateEngine = (MarkupTemplateEngine)templateEngineProvider.getIfAvailable();
        }

        @PostConstruct
        public void checkTemplateLocationExists() {
            TemplateLocation location;
            if (this.properties.isCheckTemplateLocation() && !this.isUsingGroovyAllJar() && !(location = new TemplateLocation(this.properties.getResourceLoaderPath())).exists((ResourcePatternResolver)this.applicationContext)) {
                logger.warn((Object)("Cannot find template location: " + location + " (please add some templates, check your Groovy configuration, or set spring.groovy.template.check-template-location=false)"));
            }
        }

        private boolean isUsingGroovyAllJar() {
            try {
                ProtectionDomain domain = MarkupTemplateEngine.class.getProtectionDomain();
                CodeSource codeSource = domain.getCodeSource();
                return codeSource != null && codeSource.getLocation().toString().contains("-all");
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Bean
        @ConditionalOnMissingBean(value={GroovyMarkupConfig.class})
        @ConfigurationProperties(prefix="spring.groovy.template.configuration")
        public GroovyMarkupConfigurer groovyMarkupConfigurer() {
            GroovyMarkupConfigurer configurer = new GroovyMarkupConfigurer();
            configurer.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            configurer.setCacheTemplates(this.properties.isCache());
            if (this.templateEngine != null) {
                configurer.setTemplateEngine(this.templateEngine);
            }
            return configurer;
        }
    }
}

