/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.tree;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.dependency.tree.AbstractSerializingVisitor;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class TGFDependencyNodeVisitor
extends AbstractSerializingVisitor
implements DependencyNodeVisitor {
    private List<EdgeAppender> edges = new ArrayList<EdgeAppender>();

    public TGFDependencyNodeVisitor(Writer writer) {
        super(writer);
    }

    public boolean endVisit(DependencyNode node) {
        if (node.getParent() == null || node.getParent() == node) {
            this.writer.println("#");
            for (EdgeAppender edge : this.edges) {
                this.writer.println(edge.toString());
            }
        } else {
            DependencyNode p = node.getParent();
            this.edges.add(new EdgeAppender(p, node, node.getArtifact().getScope()));
        }
        return true;
    }

    public boolean visit(DependencyNode node) {
        this.writer.write(TGFDependencyNodeVisitor.generateId(node));
        this.writer.write(" ");
        this.writer.println(node.toNodeString());
        return true;
    }

    private static String generateId(DependencyNode node) {
        return String.valueOf(node.hashCode());
    }

    static final class EdgeAppender {
        private DependencyNode from;
        private DependencyNode to;
        private String label;

        public EdgeAppender(DependencyNode from, DependencyNode to, String label) {
            this.from = from;
            this.to = to;
            this.label = label;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(TGFDependencyNodeVisitor.generateId(this.from));
            result.append(' ').append(TGFDependencyNodeVisitor.generateId(this.to));
            if (this.label != null) {
                result.append(' ').append(this.label);
            }
            return result.toString();
        }
    }
}

