// import Layout from '@/components/Layout' 
// import Home from '@/views/home' 
// import LoginPage from '@/views/login'
// import PersonCenter from '@/views/person-center'
// import TipsNoAuth from '@/views/errorTips/auth' 
// import TipsNetworkErr from '@/views/errorTips/network' 
// import ContentWrapper from '@/components/Layout/content-wrapper' 
// import basicInfo from '@/views/houseData/basicInfo'
// import PropertyInfo from '@/views/houseData/propertyInfo'
// import CmDivision from '@/views/houseData/cmDivision'
// import Managers from '@/views/houseData/managers'
// import IndCous from '@/views/houseData/indCous'
// import NonResidents from '@/views/houseData/nonResidents'
// import Buildings from '@/views/houseData/buildings'
// import Members from '@/views/houseData/members'
// import BasicView from '@/views/houseData/basicView'
// import Shebei from '@/views/houseData/shebei'
// import PropertyInfoView from '@/views/houseData/propertyInfoView'
// import Tbls from '@/views/houseData/tbls'
// import Demo from '@/views/components/demo' 
const appRoutes = [
  {
    path: '/', name: 'Layout', redirect: '/businessSystem/businessSystemList',
    component: resolve => require(['@/components/Layout'], resolve), //Layout,
    children: [
      {
        path: '/businessSystem', name: 'businessSystem', component: resolve => require(['@/components/Layout/content-wrapper'], resolve), //ContentWrapper,
        meta: { title: '业务系统', menuPath: true, menuIcon: 'profile', authCode: '0000', hideInBread: false },
        children: [
          {
            path: '/businessSystem/businessSystemList', name: 'businessSystemList', component: resolve => require(['@/views/businessSystem/businessSystemList.vue'], resolve), //basicInfo,
            meta: { title: '业务系统', menuPath: true, hideInBread: false, },
          },
        ]
      },
      {
        path: '/action', name: 'action', component: resolve => require(['@/components/Layout/content-wrapper'], resolve), //ContentWrapper,
        meta: { title: 'Action', menuPath: true, menuIcon: 'profile', authCode: '0000', hideInBread: true },
        children: [
          {
            path: '/action/actionList', name: 'actionList', component: resolve => require(['@/views/action/actionList.vue'], resolve), //basicInfo,
            meta: { title: 'Action', menuPath: true, hideInBread: false, },
          },
        ]
      },
      {
        path: '/executionLog', name: 'executionLog', component: resolve => require(['@/components/Layout/content-wrapper'], resolve), //ContentWrapper,
        meta: { title: '执行日志', menuPath: true, menuIcon: 'profile', authCode: '0000', hideInBread: true },
        children: [
          {
            path: '/executionLog/executionLogList', name: 'executionLogList', component: resolve => require(['@/views/executionLog/executionLogList.vue'], resolve), //basicInfo,
            meta: { title: '执行日志', menuPath: true, hideInBread: false, },
          },
        ]
      },
      {
        path: '/iftttRules', name: 'iftttRules', component: resolve => require(['@/components/Layout/content-wrapper'], resolve), //ContentWrapper,
        meta: { title: '规则', menuPath: true, menuIcon: 'profile', authCode: '0000', hideInBread: true },
        children: [
          {
            path: '/iftttRules/iftttRulesList', name: 'iftttRulesList', component: resolve => require(['@/views/iftttRules/iftttRulesList.vue'], resolve), //basicInfo,
            meta: { title: '规则列表', menuPath: true, hideInBread: false, },
          },
        ]
      },
    ],
  },
  {
    path: '/login',
    name: 'login',
    meta: { title: '登录' },
    component: resolve => require(['@/views/login'], resolve), //LoginPage,
  },
  { path: '/networkerr', name: 'networkErr', component: resolve => require(['@/views/errorTips/network'], resolve), //TipsNetworkErr,
    meta: { title: '网络异常', },
  },
  { path: '/demo', name: 'demo', component: resolve => require(['@/views/components/demo'], resolve), //Demo,
    meta: { title: 'demo', },
  },
]

export const routes = [
  ...appRoutes,
]