import TipsOutsite from '@/views/tips/outside'
import pudong from '@/router/pudongRoutes.json'
import xuhui from '@/router/xuhuiRoutes.json'

async function GetRoutes(router) {
  let env = process.env.NODE_ENV
  console.log(env)
  let MicRouters
  switch (env) {
  case env.indexOf('pudong') > -1: // 根据当前打包的项目调用该项目对应的路由
    MicRouters = pudong
    break

  case env.indexOf('xuhui') > -1:
    MicRouters = xuhui
    break
    
  default: // 当前仅可使用pudong / xuhui-sit/uat进行打包
    MicRouters = pudong
    break
  }

  const micSystemRoutersConfigs = Object.assign({}, MicRouters)
  const { routes } = router.options
  const parent = routes.find(item => item.name === 'Layout')
  for (let key in micSystemRoutersConfigs) {
    for (let i = 0; i < micSystemRoutersConfigs[key].length; i++) {
      let firstRouter = Object.assign({}, micSystemRoutersConfigs[key][i])
      if (
        !!firstRouter.meta.openMode &&
        firstRouter.meta.openMode == 'outsite'
      ) {
        firstRouter.component = TipsOutsite
      }
      parent.children.push(Object.assign({}, firstRouter))
      router.addRoutes([ parent ])
    }
  }
}

export default GetRoutes
