let BASE_URL = '', MOCK_URL=''
/**
 * todo
 * 1、此处配置当前项目在不同环境下的API请求前缀
 * 2、前端服务间、后端服务间需做跨域处理
 */
switch (process.env.NODE_ENV) {
case 'devol': // 本地线上部署环境下
  // BASE_URL = 'http://search.omniview.pro/api'
  BASE_URL = 'http://211.136.105.193/apiv2'

  break
case 'sit': // sit环境下
  // BASE_URL = 'http://search.omniview.pro/api'
  BASE_URL = 'http://211.136.105.193/apiv2'

  break
case 'uat': // uat环境下
  // BASE_URL = 'http://search.omniview.pro/api'
  BASE_URL = 'http://211.136.105.193/apiv2'

  break
case 'production': // 生产环境下
  // BASE_URL = 'http://search.omniview.pro/api'
  BASE_URL = 'http://211.136.105.193/apiv2'    //浦东
  // BASE_URL = 'http://31.0.161.39/apiv2'     //徐汇
  // BASE_URL = 'http://hm.omniview.pro/api'


  break
default: // 默认环境下（开发环境）
  // BASE_URL = 'http://211.136.105.193/apiv2'
  // BASE_URL = 'http://31.0.161.39/apiv2'
  BASE_URL = 'http://hm.omniview.pro/api'


  MOCK_URL = 'https://yapi.omniview.pro/mock/278'
  break
};
/**
 * 此处配置本项目涉及到的所有
 * 要求
 * 1、前端服务间、后端服务间需做跨域处理
 * 2、所有的API都需要注释说明，标记业务动作是什么
 * 3、在API的名称定义上，需体现本接口的请求方式。如USERINFO_POST、USERINFO_GET
 * 4、所有的API按功能模块要求，分段并注释说明
 */
export default {
  /**
   * 各类请求的BASE_URL
   */
  BASE_URL,

  GET_USER_INFO: '/service-user/login/user/info', // 获取用户信息

  PUT_PERSONAL_RESET_PWD:'service-user/pwd', // 修改密码


  GET_KEYS:'service-customkey/show/{table}/keys', // 某表下所有可显示的字段
  POST_KEYS:'service-customkey/show/keys',// 保存已选字段
  GET_CAN_TBLS:'service-customkey/tbls',// 可进行数据拓展的表
  GET_CONFIG:'config',//判断自定义字段功能是否开启
  GET_PROJECT:'/service-search/public/projectConfig',//查看项目信息
  POST_PROJECT:'/service-search/projectConfig',//配置项目信息
  UPLOAD_TEMP:'/service-search/img/temp',//项目图片上传

  GET_TBLS_LIST:'service-customkey/tbls', // 可进行数据拓展的表
  POST_TBLS_KEYS:'service-customkey/key', // 新增自定义字段
  PUT_TBLS_KEYS:'service-customkey/key/{id}', // 修改自定义字段
  DELETE_TBLS_KEYS:'service-customkey/key/{id}', // 删除自定义字段

  GET_TBLS_KEYS:'service-customkey/keys', // 某表下有哪些自定义字段

  GET_EXT:'/service-search/entity/{id}/ext', // 查看某数据的自定义信息
  POST_EXT:'/service-search/entity/ext', // 保存某数据的自定义信息
  GET_SAFE_EXT:'/service-search/{table}/entity/{id}/ext', // 维护自定义信息的借口
  POST_EXT_BATCH:'/service-search/entity/ext/batch', // 批量操作




  GET_EXPORT:'/service-search/export/{table}',//数据导出
  GET_STREET_LIST:'/service-search/streets',  //街道下拉列表

  // 小区列表
  GET_BASIC_LIST: '/service-search/communities',
  // 小区详情
  GET_BASIC_ID: '/service-search/community/{id}',
  // 物业服务企业列表
  GET_PROPCOMPANIES_LIST:'/service-search/propCompanies',
  // 物业服务企业详情
  GET_PROPCOMPANY_ID: '/service-search/propCompany/{id}',
  // 小区管理处列表
  GET_CSS_LIST: '/service-search/css',
  // 小区管理处详情
  GET_CS_ID: '/service-search/css/{id}',
  // 小区经理列表
  GET_MANAGERS_LIST: '/service-search/managers',
  // 小区经理详情
  GET_MANAGER_ID: '/service-search/manager/{id}',
  // 业委会列表
  GET_INDCOUS_LIST: '/service-search/indCous',
  // 业委会详情
  GET_INDCOU_ID:'/service-search/indCou/{id}',
  // 非居列表
  GET_NONRESIDENTS_LIST: '/service-search/nonResidents',
  // 非居详情
  GET_NONRESIDENT_ID: '/service-search/nonResident/{id}',
  // 小区楼栋列表
  GET_BUILDINGS_LIST: '/service-search/community/buildings',
  // 小去楼栋详情
  GET_BUILDING_ID:'/service-search/community/building/{id}',
  // 业委会成员列表
  GET_MEMBERS_LIST: '/service-search/indcou/members',
  // 业委会成员详情
  GET_MEMBER_ID: '/service-search/indcou/member/{id}',
  // 设施设备列表
  GET_FACEQUS_LIST: '/service-search/community/facEqus',
  // 房办列表
  GET_HOS_LIST: '/service-search/hos',
  // 首页统计列表
  GET_RESOURE_LIST: '/service-search/resource/count',
  // 首页统计列表
  POST_LOGIN: '/service-user/public/login',

  /**
   * SSO
   */
  GET_TOKEN: BASE_URL+'/uaa/oauth/token', // 获取token
  /**
   * XXX审查
   */
  SHENGCHA_POST:'', // 提交需要XX审查的数据信息
}
